# Name:     toUTF8.ps1
# Purpose:  This PowerShell script converts *.TEX and *.BIB files in UTF8 encoding. Use right-click on this script and Run with Powershell. Then package the folder in a ZIP file.
# Author:   Marek Bhm Marek.Bohm@student.copsu.cz
# Revision: November 2021 - initial version

CLS

$CurrentPath = (Get-Item -Path $MyInvocation.MyCommand.Path).Directory.FullName
Write-Host "The current directory is $CurrentPath"

CD $CurrentPath

# .tex files
Foreach($i in ls -recurse -filter "*.tex") {
    $temp = Get-Content $i.fullname
    Out-File -filepath $i.fullname -inputobject $temp -Encoding utf8 -Force
    Write-Host "The $i file was saved in UTF8 encoding."
    }

# .bib files
Foreach($i in ls -recurse -filter "*.bib") {
    $temp = Get-Content $i.fullname
    Out-File -filepath $i.fullname -inputobject $CurrentPath+$temp -Encoding utf8 -Force
    Write-Host "The $i file was saved in UTF8 encoding."
    }

PAUSE