clc; clear; close all

%% Model name and ModelMask name
ModelName = 'WaterTank';
ModelMaskName = 'WATER TANK VR Model';


%% Simulink Scheme to EPS and PNG
open_system(sprintf('%s.mdl',ModelName));
get_param(ModelName, 'PaperType')
get_param(ModelName, 'PaperOrientation')
get_param(ModelName, 'PaperPositionMode')
get_param(ModelName, 'PaperPosition')
set_param(ModelName, 'PaperOrientation', 'portrait')
    print(sprintf('-s%s',ModelName),'-depsc2','../../Figures/ModelWS');
    print(sprintf('-s%s',ModelName),'-dpng','../../Figures/ModelWS');
open_system(sprintf('%s/%s',ModelName,ModelMaskName), 'force');
set_param(sprintf('%s/%s',ModelName,ModelMaskName), 'PaperOrientation', 'portrait')
    print(sprintf('-s%s/%s',ModelName,ModelMaskName),'-depsc2','../../Figures/ModelWSunderMask');
    print(sprintf('-s%s/%s',ModelName,ModelMaskName),'-dpng','../../Figures/ModelWSunderMask');
bdclose(sprintf('%s.mdl',ModelName));


%% Graphs
MODEL = fopen(sprintf('%s.mdl',ModelName));
sim(ModelName,1000);
fclose(MODEL);

vz = 50;
figure(1)
    plot(tu(1:vz:end,1),tu(1:vz:end,2),'r');
    grid on
FigPlot(1,'t [s]','u [V]',16,'',16,4);
axis([xlim 0 11]);
print(1,'-depsc2','../../Figures/Data_u');

figure(2)
    plot(ty(1:vz:end,1),ty(1:vz:end,2),'b');
    grid on
FigPlot(2,'t [s]','h [cm]',16,'',16,4);
print(2,'-depsc2','../../Figures/Data_h');